-- 1. a)
select ename, job, sal,
       sal - lag(sal) over (order by sal) diff_sal
  from emp
 order by sal;
  
-- 1. b)
select deptno, ename, job, sal,
       sal - lag(sal) over (partition by deptno order by deptno, sal) diff_sal
  from emp
 order by deptno, sal;
 
-- 2.
select deptno, ename, job, sal,
       round(avg(sal) over (partition by deptno), 2) avg_dept_sal
  from emp
 order by deptno, sal;

-- 3.
select deptno, ename, hiredate,
       numtoyminterval(
         months_between(
           hiredate, 
           lag(hiredate) over (order by hiredate)), 'month') intervall,
       numtoyminterval(
         months_between(
           hiredate, 
           lag(hiredate) over (partition by deptno order by hiredate)), 'month') intervall_dept
  from emp
 order by hiredate;
 
-- 4.
select deptno, 
       round(avg(sal), 2) sal_avg,
       rank() over (order by avg(sal) desc) rank_avg, 
       sum(sal) sal_sum,
       rank() over (order by sum(sal) desc) rank_sum
  from emp
 group by deptno;
 
-- 5. a)
select ename, sal, 
       sal - first_value(sal) over (order by sal) diff_min_sal, 
       first_value(sal) over (order by sal desc) - sal diff_max_sal
  from emp
 order by sal;

-- 5. b)
select deptno, ename, sal, 
       sal - first_value(sal) over (partition by deptno order by sal) diff_min_sal, 
       first_value(sal) over (partition by deptno order by sal desc) - sal diff_max_sal
  from emp
 order by deptno, sal;
 
-- 6. Sie würde funkionieren, allerdings ist hierfür eine windowing-Klausel erforderlich.
-- Standardmäßig lautet die Klause rows unbounded preceding and current row. Daher ist
-- als Maximalwert bei normaler Sortierung stets das aktuelle Gehalt die Maximalgröße, die Differenz also 0.
-- Hier die Auswertung mit last_value:
select deptno, ename, sal, 
       sal - first_value(sal) over (partition by deptno order by sal) diff_min_sal, 
       last_value(sal) over (partition by deptno -- optional
                             order by sal 
                             range between current row and unbounded following)
         - sal diff_max_sal
  from emp
 order by deptno, sal;